
function Spriteset(spriteset) {
  this.spriteset = spriteset;
}

Spriteset.prototype.getFrame = function(direction_index, frame_index) {
  return (this.spriteset.images[this.spriteset.directions[direction_index].frames[frame_index].index]);
}

Spriteset.prototype.getNumFrames = function(direction_index){
  // returns total frames for the direction index
  return (this.spriteset.directions[direction_index].frames.length);
}

Spriteset.getNumDirections = function() {
  return (this.spriteset.directions.length);
}

var OldLoadSpriteset      = LoadSpriteset;
var OldSetPersonDirection = SetPersonDirection;
var OldGetPersonDirection = GetPersonDirection;

function init_old_spriteset_code() {
  LoadSpriteset = function(filename) {
    return new Spriteset(OldLoadSpriteset(filename));
  }

  SetPersonDirection = function(name, direction_index) {
    OldSetPersonDirection(name, GetPersonSpriteset(name).directions[direction_index].name);
  }

  GetPersonDirection = function(name) {
    var direction = OldGetPersonDirection(name);
    var spriteset = GetPersonSpriteset(name)
    for (var SPi = 0; SPi < spriteset.directions.length; SPi++)
      if (spriteset.directions[SPi].name == direction)
        return (SPi);
  return 0;}

}

init_old_spriteset_code();